#!/usr/bin/env python
# Set Plan Bar Color To Default.py
# Copyright 2005 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 050627 - Clear the PlanBarColor for all rows in report
# 051210 - Brian - limit changes to selected rows if rows are selected

import wx
import re

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

if debug: print 'Start Script'


def SetPlanBarColor(self):

    # set local pointers to tables
    rid = self.ReportID  # current report
    drep = Data.Database['Report']
    drow = Data.Database['ReportRow']
    drt = Data.Database['ReportType']
    rr = drep[rid]

    # make sure report has report type
    if not rr.has_key('ReportTypeID') or not drt.has_key(rr['ReportTypeID']): 
        if debug: print "ReportType key not found"
        hint("Error: Can't find type of this report.")
        return
    rtid = rr['ReportTypeID']

    # is this a task report
    rt = drt[rtid] # pointer to report type record
    ta = rt.get('TableA')
    tb = rt.get('TableB')  # if two table report all inserts go at the end (less confusing to user)
    if not (ta == 'Task' or tb == 'Task'):
        hint('Use script only with Task reports.')
        return

    # change either the selection, if there is one, or all visible rows
    rows = [ self.Report.table.rows[x] for x in self.Report.GetSelectedRows() ]  # current selection -> row ids
    if not rows:
        # update all visible rows
        rows = self.Report.table.rows  # all visible rows in display order

    # get row ids for all task rows
    rids = [ x for x in rows if drow[x].get('TableName') == 'Task' ]

    # clear color for each row
    newcolor = None
    for rowid in rids:
        if drow[rowid].get('PlanBarColor') != newcolor:
            change = { 'Table': 'ReportRow', 'ID': rowid, 'PlanBarColor': newcolor }
            Data.Update(change)

    Data.SetUndo('Set Plan Bar Color To Default')


SetPlanBarColor(self)

if debug: print 'End Script'
